% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_select.r
\name{umi_gene_stat}
\alias{umi_gene_stat}
\title{Calculate basic statistics on a matrix}
\usage{
umi_gene_stat(scmat, niche_quantile = 0.2, rseed = 321, downsample_n = NA)
}
\arguments{
\item{niche_quantile}{A value between 0 and 1.}

\item{mat}{The input matrix}
}
\value{
Returns a dataset that contains statistic for all genes that passed the filtering stage.
Columns starting with ds contain UMI statistics after downsampling,
columns starting with n contain UMI statistics after normalizing UMIs so that the number of UMIs
per cell sums to 1.

The columns are:

\describe{
  \item{tot}{Total gene expression}
  \item{var}{Gene variance}
  \item{is_on_count}{Number of cells in which the gene is expressed}
  \item{sz_cor}{Correlation with cell size}
  \item{sz_cor_norm}{sz_cor after subtracting the trend}
  \item{niche_stat}{How many of the genen's umis are found in X\% of the most highly expressing cells. (regularized) }
  \item{niche_norm}{niche_stat after subtracting the niche_norm trend: median niche_norm value of genes with similar total expression}
  \item{n_mean}{Mean after normalization}
  \item{ds_top1}{Largest count, after downsampling}
  \item{ds_top2}{2nd largest count, after downsampling}
  \item{ds_top3}{3rd largest count, after downsampling}
  \item{ds_mean}{Mean on downsampled data}
  \item{ds_var}{Variance on downsampled data}
  \item{ds_log_varmean}{log2 of ds_var/ds_mean }
  \item{ds_vm_norm}{ds_log_varmean after subtracting the trend}
  \item{ds_is_on_count}{Number of cells in which the gene is expressed, after down sampling}
  \item{downsample_n}{Number of UMIs used for downsampling}

}
}
\description{
Calculate basic statistics on a matrix
}
