% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scmat.r
\docType{class}
\name{tgScMat-class}
\alias{tgScMat-class}
\alias{tgScMat}
\title{Single cell RNA-seq matrix}
\description{
a single cell RNA matrix interface. Does not do much beyond adding
specifically gene names, cell names and labels describing the type of data.
Methods for basic stat, gene selection, clustering are implemented separately
}
\section{Slots}{

\describe{
\item{\code{mat}}{A sparse matrix containing the expression data}

\item{\code{Genes}}{list of all genes}

\item{\code{Cells}}{list of all cells}

\item{\code{stat_type}}{Type of statistic. ("umi", "rpkm", "tpm" etc.)}

\item{\code{feature_type}}{.}

\item{\code{cell_metadata}}{dataframe with metadata on the cells. Rownames correspond to the cell names.}
}}

\examples{
# we first initialize a tgScMat object
scmat = tgScMat(mat=scrdb::toydata, stat_type="umi")

# we next compute gene markers, while also dumping stats into a figure gset.png
# this stage likely requires intervention by tuning parameters
marks = tgscm_gene_select(scmat)

# we next cluster using the knn graph approach and default parameters
scl = tgScMatClust(scmat=scmat, feat_mat=scmat@mat[marks,], alg_type="knn_graph")
scl_kmeans = tgScMatClust(scmat=scmat, feat_mat=scmat@mat[marks,], alg_type="kmeans")

# we then compute the graph/cells 2d layout
scl_2d = tgScMatClustLayout2D(scl=scl, alg_type="graph", T_edge=0.08)

# optionally you can save the data, clusteirng and layout for later loading (note that the sc mat
# will be duplicated - altohugh options to prevent this are available
tgscm_export(scl_2d, file="fig/toydata")

# plotting the clusters and cells around them - with some default coloring scheme that will
# usually won't cut it (unless the model is really small)

tgscm_plot_clust_2d(scl_2d)

# we can now plot the density map for each marker genes
for(nm in marks) {
  tgscm_plot_gene_2d(scl_2d,gene_nm=nm, reg_factor=5, w=2000,h=2000,base_dir="fig/")
}

}
