% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scmat.r
\name{scm_read_scmat_mars}
\alias{scm_read_scmat_mars}
\title{Read a matrix from the output of a MARS-Seq run}
\usage{
scm_read_scmat_mars(base_dir, mars_batches = NULL, batch_meta_file = NULL,
  batch_meta = NULL, skip_missing = T, genes_by_first = T,
  min_umis_n = 200, stats_fn_pref = NULL)
}
\arguments{
\item{base_dir}{base directory of MARS pipeline}

\item{mars_batches}{all mars technical (amplification) batch codes. If null, will read all batches listed in batch_metadata.}

\item{batch_meta_file}{path to a tab delimited file describing the mars batches. First column must be batch name.
Exactly one of \code{batch_meta_file}, \code{batch_meta} should be used.}

\item{batch_meta}{a data frame describing the mars batches.
Exactly one of \code{batch_meta_file}, \code{batch_meta} should be used.}

\item{skip_missing}{Skip batches that are present in the metadata file but a missing from the UMI directory?}

\item{min_umis_n}{minimum number of umi's for retaining the cell in the matrix}
}
\description{
Read a matrix from the output of a MARS-Seq run
}
