% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_mods.r
\name{scgm_from_clusts}
\alias{scgm_from_clusts}
\title{Given a cell cluster solution, this will cluster genes given either their
cluster enrichment per cluster, or given the deviation of their expression
from the cluster mean predictions (residual expression)}
\usage{
scgm_from_clusts(scl, feat_type = "clust_fp", foc_genes = NULL,
  min_fold = 2, use_hclust = F, k_clusts = NA, k_knn = NA,
  min_tot = 200, cor_method = "pearson", report_dir = ".", rseed = 1)
}
\arguments{
\item{scl}{A tgScMatClust cell cluster object}

\item{feat_type}{- "clust_fp" is using cluster enrichment, "resid" for residuals}

\item{foc_genes}{- genes for analysis (i.e. only genes with enough stat)}

\item{use_hclust}{- if this is false, use knn_clust}

\item{k_clusts}{number of clusters if using hclust}

\item{k_knn}{number of clusters if using knn clustering}
}
\value{
A tgScGeneMod object
}
\description{
Given a cell cluster solution, this will cluster genes given either their
cluster enrichment per cluster, or given the deviation of their expression
from the cluster mean predictions (residual expression)
}
